/*
    eject

    Dieses Programm sucht sich ber setmntent() gemontete CD-Rom
    Laufwerke umountet sie und ffnet das CD-Rom-Laufwerk.

    Copyright (C) Andreas Hofmeier

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


    Name:     Andreas Hofmeier

    Adresse:  Stralsunder Strae 20
              28239 Bremen
              Germany

    Telefon:  +49-421-613793

    eMail:    An-H@An-H.de
              hofmeier@inbremen.de
              an-h@gmx.de

    Homepage: http://www.An-H.de/
	      hofmeier.home.pages.de
              http://www.LGut.uni-bremen.de/anh/



*/


#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/cdrom.h>
#include "hofmeier.h"
#include <mntent.h>
#include <errno.h>


char blacky_ver_info[] = "Blacky Eject v0.07 (c) Copyright 1998-2000 Andreas Hofmeier";


const char* DEV = "/dev/cdrom";
const int BAD = 1;
const int GOOD = 0;


int main(int argc, char** argv)
{
  int fd, fp;
  struct mntent *mnt;
  char command[500];

  if ((argc > 1) ? ((argv[1][0] == '-') && ((argv[1][1] == '?') || (toupper(argv[1][1]) == 'H'))) : 0) {
    printf("Help:\n");
    printf("  bcd [CD-Rom-Device] [-v]\n");
    printf("    -v: Version, Licenze\n");
    exit(0);
  }

  if ((argc == 2) ? ((argv[1][0] == '-') && (toupper(argv[1][1]) == 'V')) : 0) {
    printf("%s\n\n", blacky_ver_info);
    printkinfo(stdout);
    exit(0);
  }

  /* Suchen umounten und eject */
  if ((fp = setmntent(MOUNTED, "r")) == NULL) {
    fprintf (stderr, "Couldn't open %s: %s\n", MOUNTED, strerror (errno));
    perror("setmntent(MOUNTED, \"r\")");
    exit (1);
  }
  while ((mnt = getmntent (fp)) != NULL) {
    if (strcmp (mnt->mnt_type, "iso9660") == 0) {
      if (geteuid() == 0) { /* Root-Rechte, sudo unntig. */
	sprintf(command, "umount %s", mnt->mnt_dir);
      } else {              /* Normaler USER-Versuche sudo...*/
	sprintf(command, "sudo umount %s", mnt->mnt_dir);
      }
      system(command);
      if (-1 == (fd = open(mnt->mnt_fsname, O_RDONLY))) {
	perror(mnt->mnt_fsname);
	exit(BAD);
      }
      if (-1 == ioctl(fd, CDROMEJECT, NULL)) {
	perror(mnt->mnt_fsname);
	exit(BAD);
      }
      endmntent (fp);
      exit(GOOD);
    }
  }
  endmntent(fp);
  
  /* nur ejekt */
  if (-1 == (fd = open( (argc > 1) ? argv[1] : DEV , O_RDONLY))) {
    perror(argv[0]);
    exit(BAD);
  }
  if (-1 == ioctl(fd, CDROMEJECT, NULL)) {
    perror(argv[0]);
    exit(BAD);
  }
  exit(GOOD);
}
